<?php
/**
 * Scalapay
 *
 * @author Scalapay Plugin Integration Team
 *
 * Copyright © All rights reserved.
 * See LICENCE.md for license details.
 */

declare(strict_types=1);

namespace Scalapay\Scalapay\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;
use Throwable;

class Migration1695803117RemoveOldSettings extends MigrationStep
{
    /**
     * {@inheritDoc}
     *
     * @return int
     */
    public function getCreationTimestamp(): int
    {
        return 1695803117;
    }

    /**
     * {@inheritDoc}
     *
     * @return void
     */
    public function update(Connection $connection): void
    {
        // delete old configuration keys
        $query = <<<SQL
            DELETE FROM `system_config` WHERE `configuration_key` IN (
                "Scalapay.config.paymentScalapayNumberOfPayments",
                "Scalapay.config.paymentScalapayCartLogoAlignment", 
                "Scalapay.config.paymentScalapayCartLogoColor",
                "Scalapay.config.paymentScalapayCartLogoPriceColor",
                "Scalapay.config.paymentScalapayCartPageApplyMinOrderValue",
                "Scalapay.config.paymentScalapayCartPriceboxSelector",
                "Scalapay.config.paymentScalapayCartShowhideLogo",
                "Scalapay.config.paymentScalapayCartSize",                                         
                "Scalapay.config.paymentScalapayProductLogoAlignment", 
                "Scalapay.config.paymentScalapayProductLogoColor",
                "Scalapay.config.paymentScalapayProductLogoPriceColor",
                "Scalapay.config.paymentScalapayProductPageApplyMinOrderValue",
                "Scalapay.config.paymentScalapayProductPriceboxSelector",
                "Scalapay.config.paymentScalapayProductShowhideLogo",
                "Scalapay.config.paymentScalapayProductSize"
            );
        SQL;
        try {
            $connection->executeStatement($query);
        } catch (Throwable) {
        }
    }

    /**
     * {@inheritDoc}
     *
     * @return void
     */
    public function updateDestructive(Connection $connection): void
    {
        // no destructive updates
    }
}
