<?php
/**
 * Scalapay
 *
 * @author Scalapay Plugin Integration Team
 *
 * Copyright © All rights reserved.
 * See LICENCE.md for license details.
 */

declare(strict_types=1);

namespace Scalapay\Scalapay\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;
use Throwable;

class Migration1695821168UpdateSettingsKey extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1695821168;
    }

    public function update(Connection $connection): void
    {
        // update configuration keys with new plugin name
        $query = <<<SQL
           update system_config
            set configuration_key = replace(configuration_key, 'Scalapay.config.', 'ScalapayPayments.config.')
            where configuration_key like 'Scalapay.config.%';
        SQL;
        try {
            $connection->executeStatement($query);
        } catch (Throwable) {
        }
    }

    public function updateDestructive(Connection $connection): void
    {
        // no destructive updates
    }
}
