<?php
/**
 * Scalapay
 *
 * @author Scalapay Plugin Integration Team
 *
 * Copyright © All rights reserved.
 * See LICENCE.md for license details.
 */

declare(strict_types=1);

namespace Scalapay\Scalapay\PaymentMethods;

interface PaymentMethodInterface
{
    public const PRODUCT_TYPE = 'product';

    public const CART_TYPE = 'cart';

    /**
     * Return name of the payment method.
     *
     * @return string
     */
    public function getName(): string;

    /**
     * Return the description of the payment method.
     *
     * @return string
     */
    public function getDescription(): string;

    /**
     * Return the payment handler of a plugin.
     *
     * @return string
     */
    public function getPaymentHandler(): string;

    /**
     * Return the gateway code used for the API.
     *
     * @return string
     */
    public function getGatewayCode(): string;

    /**
     * Give the location of the payment logo.
     *
     * @return string
     */
    public function getMedia(): string;

    /**
     * Get payment method translations
     *
     * @return array
     */
    public function getTranslations(): array;

    /**
     * Get the type that is currently being used.
     *
     * @return string
     */
    public function getType(): string;
}
