<?php
/**
 * Scalapay
 *
 * @author Scalapay Plugin Integration Team
 *
 * Copyright © All rights reserved.
 * See LICENCE.md for license details.
 */

declare(strict_types=1);

namespace Scalapay\Scalapay\PaymentMethods;

use Scalapay\Scalapay\Handlers\ScalapayPaymentHandler;

class ScalapayPaymentMethod implements PaymentMethodInterface
{

    /**
     * {@inheritDoc}
     *
     * @return string
     */
    public function getName(): string
    {
        return 'Scalapay - Pay in installments';
    }

    /**
     * {@inheritDoc}
     *
     * @return string
     */
    public function getDescription(): string
    {
        return 'Receive your order now. Enjoy it and take your time to pay little by little.';
    }

    /**
     * {@inheritDoc}
     *
     * @return string
     */
    public function getPaymentHandler(): string
    {
        return ScalapayPaymentHandler::class;
    }

    /**
     * {@inheritDoc}
     *
     * @return string
     */
    public function getGatewayCode(): string
    {
        return 'SCALAPAY';
    }

    /**
     * {@inheritDoc}
     *
     * @return string
     */
    public function getMedia(): string
    {
        return __DIR__ . '/../Resources/public/storefront/img/scalapay-logo.png';
    }

    /**
     * {@inheritDoc}
     *
     * @return array
     */
    public function getTranslations(): array
    {
        return [
            'de-DE' => [
                'name' => 'Scalapay - Bezahle in Raten',
                'description' => 'Deine Bestellung wird sofort versendet. Genieße Deinen Einkauf und nimmt Dir Zeit, ihn langsam zu bezahlen.'
            ],
            'en-GB' => [
                'name' => $this->getName(),
                'description' => $this->getDescription(),
            ],
            'es-ES' => [
                'name' => 'Scalapay - Paga en plazos',
                'description' => 'Recibe tu pedido ahora. Disfruta de la compra y págala poco a poco.',
            ],
            'it-IT' => [
                'name' => 'Scalapay - Paga a rate',
                'description' => 'Ricevi subito il tuo ordine. Goditi il tuo acquisto e prenditi il tempo per pagarlo lentamente.',
            ],
            'fr-FR' => [
                'name' => 'Scalapay - Payez en plusieurs fois',
                'description' => 'Recevez votre commande immédiatement. Profitez de votre achat et prenez votre temps pour le payer.',
            ],
        ];
    }

    /**
     * {@inheritDoc}
     *
     * @return string
     */
    public function getType(): string
    {
        return 'redirect';
    }
}
