import template from './sw-order-detail.html.twig';

const {Context} = Shopware;
const Criteria = Shopware.Data.Criteria;

const scalapayFormattedHandlerIdentifier = 'handler_scalapay_scalapaypaymenthandler';

Shopware.Component.override('sw-order-detail-details', {
    template,

    data() {
        return {
            scalapayToken: null
        };
    },

    computed: {},

    watch: {
        orderId: {
            deep: true,
            handler() {
                if (!this.orderId) {
                    return;
                }

                const orderCriteria = new Criteria(1, 1);
                orderCriteria.addAssociation('transactions');
                orderCriteria.getAssociation('transactions').addSorting(Criteria.sort('createdAt'));

                this.repositoryFactory.create('order').get(this.orderId, Context.api, orderCriteria).then((order) => {

                    const totalTransactions = order.transactions.length;
                    const lastTransactionIndex = totalTransactions - 1;
                    if (totalTransactions <= 0 || !order.transactions[lastTransactionIndex].paymentMethodId) {
                        return;
                    }

                    const paymentMethodId = order.transactions[lastTransactionIndex].paymentMethodId;
                    if (paymentMethodId === undefined || paymentMethodId === null) {
                        return;
                    }

                    const paymentMethodRepository = this.repositoryFactory.create('payment_method');
                    paymentMethodRepository.get(paymentMethodId, Context.api).then((paymentMethod) => {
                        if (paymentMethod.formattedHandlerIdentifier !== scalapayFormattedHandlerIdentifier) {
                            return;
                        }

                        if (order.transactions[lastTransactionIndex].customFields === undefined || order.transactions[lastTransactionIndex].customFields === null) {
                            return;
                        }

                        const scalapayOrderToken = order.transactions[lastTransactionIndex].customFields.scalapay_order_token;
                        if (scalapayOrderToken) {
                            this.setScalapayToken(scalapayOrderToken);
                        }
                    });

                });
            },
            immediate: true,
        },
    },

    methods: {

        setScalapayToken(scalapayOrderToken) {
            if (scalapayOrderToken) {
                this.scalapayToken = scalapayOrderToken;
            }

        }
    },
});
