import './components/scalapay-refund';
import './extension/sw-order-detail';
import ScalapayApiService from "./service/ScalapayApi.service";

import nlNL from './snippet/nl-NL.json';
import deDE from './snippet/de-DE.json';
import enGB from './snippet/en-GB.json';

Shopware.Module.register('scalapay-payments', {
    type: 'plugin',
    name: 'ScalapayPayments',
    title: 'scalapay-payments.general.title',
    description: 'scalapay-payments.general.description',
    version: '2.0.0',
    targetVersion: '2.0.0',
    color: '#f7cace',
    icon: 'default-action-settings',

    snippets: {
        'nl-NL': nlNL,
        'de-DE': deDE,
        'en-GB': enGB
    }
});

Shopware.Service().register('scalapayApiService', (container) => {
    const initContainer = Shopware.Application.getContainer('init');
    return new ScalapayApiService(initContainer.httpClient, container.loginService);
});