const ApiService = Shopware.Classes.ApiService;

export default class ScalapayApiService extends ApiService {
    constructor(httpClient, loginService, apiEndpoint = 'scalapay') {
        super(httpClient, loginService, apiEndpoint);
    }

    refund(amount, orderId, scalapayOrderToken, refundedAmount) {
        const apiRoute = `${this.getApiBasePath()}/refund`;

        return this.httpClient.post(apiRoute, {
            amount: amount, merchantReference: orderId, orderToken: scalapayOrderToken, refundedAmount
        }, {
            headers: this.getBasicHeaders()
        }).then((response) => {
            return ApiService.handleResponse(response);
        }).catch((response) => {
            return ApiService.handleResponse(response);
        });
    }

    getRefundData(orderId, scalapayOrderToken) {

        const apiRoute = `${this.getApiBasePath()}/get-refund-data`;

        return this.httpClient.post(apiRoute, {
            orderId: orderId,
            orderToken: scalapayOrderToken
        }, {
            headers: this.getBasicHeaders()
        }).then((response) => {

            return ApiService.handleResponse(response);
        }).catch((response) => {

            return ApiService.handleResponse(response);
        });
    }
}

