<?php
/**
 * Scalapay
 *
 * @author Scalapay Plugin Integration Team
 *
 * Copyright © All rights reserved.
 * See LICENCE.md for license details.
 */

declare(strict_types=1);

namespace Scalapay\Scalapay\Service;

use Shopware\Core\System\SystemConfig\SystemConfigService;


class SettingsService
{

    public const SYSTEM_CONFIG_DOMAIN = 'ScalapayPayments.config.';

    /**
     * @var SystemConfigService
     */
    public SystemConfigService $systemConfigService;

    public function __construct(SystemConfigService $systemConfigService)
    {
        $this->systemConfigService = $systemConfigService;
    }

    /**
     * @param string|null $salesChannelId
     * @return array
     */
    public function getSettings(?string $salesChannelId = null): array
    {
        $systemConfigData = $this->systemConfigService->getDomain(self::SYSTEM_CONFIG_DOMAIN, $salesChannelId, true);
        foreach ($systemConfigData as $key => $value) {
            if (stripos($key, self::SYSTEM_CONFIG_DOMAIN) !== false) {
                $structData[substr($key, strlen(self::SYSTEM_CONFIG_DOMAIN))] = $value;
            } else {
                $structData[$key] = $value;
            }
        }

        return $structData ?? [];
    }

    /**
     * @param string $setting
     * @param string|null $salesChannelId
     * @return bool|float|int|array|string|null
     */
    public function getSetting(string $setting, ?string $salesChannelId = null)
    {
        return $this->systemConfigService->get(self::SYSTEM_CONFIG_DOMAIN . $setting, $salesChannelId);
    }
}
