<?php
/**
 * Scalapay
 *
 * @author Scalapay Plugin Integration Team
 *
 * Copyright © All rights reserved.
 * See LICENCE.md for license details.
 */

declare(strict_types=1);

namespace Scalapay\Scalapay\Storefront;

use Scalapay\Scalapay\Handlers\ScalapayPaymentHandler;
use Scalapay\Scalapay\Helper\GatewayHelper;
use Shopware\Core\Checkout\Cart\Cart;
use Shopware\Core\Checkout\Cart\CartValidatorInterface;
use Shopware\Core\Checkout\Cart\Error\ErrorCollection;
use Shopware\Core\Checkout\Payment\Cart\Error\PaymentMethodBlockedError;
use Shopware\Core\System\SalesChannel\SalesChannelContext;

class PaymentMethodValidator implements CartValidatorInterface
{
    /**
     * @var GatewayHelper
     */
    protected GatewayHelper $gatewayHelper;

    /**
     * @param GatewayHelper $gatewayHelper
     */
    public function __construct(GatewayHelper $gatewayHelper)
    {
        $this->gatewayHelper = $gatewayHelper;
    }

    /**
     * @param Cart $cart
     * @param ErrorCollection $errors
     * @param SalesChannelContext $context
     * @return void
     */
    public function validate(Cart $cart, ErrorCollection $errors, SalesChannelContext $context): void
    {
        if ($context->getPaymentMethod()->getHandlerIdentifier() !== ScalapayPaymentHandler::class) {
            return;
        }

        if(!$this->gatewayHelper->isScalapayAvailable($context, $cart)){
            $errors->add(new PaymentMethodBlockedError((string) $context->getPaymentMethod()->getTranslation('name')));
        }
    }

}